<?php 
    include "../../conn.php";
    include "../../functions2.php";

    header('Content-Type: application/json; charset=utf-8');
    header('Strict-Transport-Security: max-age=31536000');
    header('Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept, Authorization');
    header('Access-Control-Allow-Credentials: true');
    $origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '';
    header('Access-Control-Allow-Origin: ' . $origin);
    header('vary: Origin');

    date_default_timezone_set("Asia/Kolkata");
    $shnunc = date("Y-m-d H:i:s");
    $res = [
        'code' => 11,
        'msg' => 'Method not allowed',
        'msgCode' => 12,
        'serviceNowTime' => $shnunc,
    ];

    try {
        $shonubody = file_get_contents("php://input");
        $shonupost = json_decode($shonubody, true);

        if ($_SERVER['REQUEST_METHOD'] != 'GET') {
            if (isset($shonupost['language']) && isset($shonupost['random']) && isset($shonupost['timestamp'])) {
                $language = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['language']));
                $random = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['random']));
                $signature = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['signature']));
                $gameCode = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['gameCode']));
                $vendorCode = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['vendorCode']));
                $bearer = explode(" ", $_SERVER['HTTP_AUTHORIZATION']);
                $author = $bearer[1];				
                $is_jwt_valid = is_jwt_valid($author);
                $data_auth = json_decode($is_jwt_valid, 1);

                if ($data_auth['status'] === 'Success') {
    // Modified query to include hold_wallet
    $sesquery = "SELECT s.id, s.codechorkamukala, s.hold_wallet 
                 FROM shonu_subjects s 
                 WHERE s.akshinak = '$author'";
    $sesresult = $conn->query($sesquery);
    if ($sesresult->num_rows == 1) {
        $user = $sesresult->fetch_assoc();
        $userId = $user['id'];
        $userCode = $user['codechorkamukala'];
        $heldAmount = isset($user['hold_wallet']) ? $user['hold_wallet'] : 0; // Default to 0 if not set

        $balanceQuery = "SELECT motta FROM shonu_kaichila WHERE balakedara = '$userId'";
        $balanceResult = $conn->query($balanceQuery);
        
        if ($balanceResult->num_rows == 1) {
            $balanceData = $balanceResult->fetch_assoc();
            $userBalance = $balanceData['motta'];
            
            if ($userBalance > 0) {
                try {
                    $orderNo = uniqid();
                    $depositResponse = depositUserBalance($userCode, $userBalance, $heldAmount);

        if ($depositResponse && isset($depositResponse['success']) && $depositResponse['success']) {
            // Update balance to keep only held amount
            $updateBalanceQuery = "UPDATE shonu_kaichila SET motta = {$user['hold_wallet']} WHERE balakedara = '$userId'";
            if ($conn->query($updateBalanceQuery) !== TRUE) {
                throw new Exception('Failed to update user balance in the database.');
            }
        
									} else {
										throw new Exception('Deposit failed: ' . ($depositResponse['message'] ?? 'Unknown error'));
									}
								} catch (Exception $e) {
									$res['code'] = 5;
									$res['msg'] = 'Deposit Error: ' . $e->getMessage();
									$res['msgCode'] = 3;
									http_response_code(500);
									echo json_encode($res);
									exit;
								}
							}
							// Call third-party API to get the launch URL
							$apiUrl = "https://dcyqv8f2id.com/api/v2/game/launch-url";
							$postData = [
								'vendorCode' => $vendorCode,
								'gameCode' => $gameCode,
								'userCode' => $userCode,
								'language' => $language,
								'lobbyUrl' => 'https://747lottery.live',
								'balance' => $userBalance
							];
							$authToken = getAuthToken();
							$ch = curl_init($apiUrl);
							curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
							curl_setopt($ch, CURLOPT_POST, true);
							curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
							curl_setopt($ch, CURLOPT_HTTPHEADER, [
								'Authorization: Bearer ' . $authToken,
								'Content-Type: application/json'
							]);
						
							curl_setopt($ch, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4); // Force IPv4
							$apiResponse = curl_exec($ch);
							$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
							curl_close($ch);
						
							if ($httpCode == 200) {
								$apiData = json_decode($apiResponse, true);
								if ($apiData && isset($apiData['success']) && $apiData['success']) {
									// Extract the URL from the 'message' field
									$url = isset($apiData['message']) ? $apiData['message'] : null;
						
									// If user balance is greater than 0, call depositUserBalance
									
						
									// Prepare the response
									$data['url'] = $url; // Add the extracted URL to the response
									$data['returnType'] = 1;
									$data['walletAmount'] = $userBalance > 0 ? 0 : $userBalance; // Balance is now 0 if deposited
									$data['userCode'] = $userCode;
						
									$res['data'] = $data;
									$res['code'] = 0;
									$res['msg'] = 'Succeed';
									$res['msgCode'] = 0;
									http_response_code(200);
									echo json_encode($res);
								} else {
									$res['code'] = 4;
									$res['msg'] = 'Failed to get launch URL';
									$res['msgCode'] = 2;
									$res['apiResponse'] = $apiResponse; // Include API response
									http_response_code(500);
									echo json_encode($res);
								}
							} else {
								$res['code'] = 4;
								$res['msg'] = 'API request failed';
								$res['msgCode'] = 2;
								$res['apiResponse'] = $apiResponse; // Include API response
								$res['httpCode'] = $httpCode; // Include HTTP status code
								http_response_code($httpCode);
								echo json_encode($res);
							}
						} else {
							$res['code'] = 4;
							$res['msg'] = 'Balance not found';
							$res['msgCode'] = 2;
							http_response_code(401);
							echo json_encode($res);
						}
                        
                    } else {
                        $res['code'] = 4;
                        $res['msg'] = 'No operation permission';
                        $res['msgCode'] = 2;
                        http_response_code(401);
                        echo json_encode($res);
                    }
                } else {					
                    $res['code'] = 4;
                    $res['msg'] = 'No operation permission';
                    $res['msgCode'] = 2;
                    http_response_code(401);
                    echo json_encode($res);					
                }
            } else {
                $res['code'] = 7;
                $res['msg'] = 'Param is Invalid';
                $res['msgCode'] = 6;
                http_response_code(200);
                echo json_encode($res);			
            }		
        } else {		
            http_response_code(405);
            echo json_encode($res);
        }
    } catch (Exception $e) {
        $res['code'] = 5;
        $res['msg'] = 'Internal Server Error: ' . $e->getMessage();
        $res['msgCode'] = 3;
        http_response_code(500);
        echo json_encode($res);
    }


	function depositUserBalance($userCode, $balance, $heldAmount) {
    if (empty($userCode) || empty($balance)) {
        throw new Exception('userCode and balance are required');
    }

    // Calculate available balance by subtracting held amount
    $availableBalance = $balance - $heldAmount;
    if ($availableBalance <= 0) {
        throw new Exception('No available balance to deposit after hold amount');
    }

    $authToken = getAuthToken();
    $depositUrl = "https://dcyqv8f2id.com/api/v2/user/deposit";

    $postData = [
        'userCode' => $userCode,
        'balance' => $availableBalance, // Send only available balance
    ];

    // ...rest of curl configuration...
    $ch = curl_init($depositUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . $authToken,
        'Content-Type: application/json'
    ]);
    curl_setopt($ch, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
	
		if ($httpCode == 200) {
			$responseData = json_decode($response, true);
			if (isset($responseData['success']) && $responseData['success']) {
				return $responseData;
			} else {
				throw new Exception('Deposit failed: ' . ($responseData['message'] ?? 'Unknown error'));
			}
		} else {
			throw new Exception('Failed to deposit. HTTP Code: ' . $httpCode . ' Response: ' . $response);
		}
	}
	function getAuthToken() {
		try {
			$authUrl = "https://dcyqv8f2id.com/api/v2/auth/createtoken";
			$postData = [
				'clientId' => 'top52-inr5',
				'clientSecret' => 'V1Umxk4UTEbKO3ZNJSt9bUAcw4LLKg1a'
			];
	
			$ch = curl_init($authUrl);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_POST, true);
			curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
			curl_setopt($ch, CURLOPT_HTTPHEADER, [
				'Content-Type: application/json',
				'Accept: application/json'
			]);
			curl_setopt($ch, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);
			$response = curl_exec($ch);
			$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
	
			// Log the request and response for debugging
			error_log('Auth Request Payload: ' . json_encode($postData));
			error_log('Auth Response: ' . $response);
			error_log('Auth HTTP Code: ' . $httpCode);
	
			if (curl_errno($ch)) {
				throw new Exception('Curl error: ' . curl_error($ch));
			}
			curl_close($ch);
	
			if ($httpCode == 200) {
				$data = json_decode($response, true);
				if (isset($data['token'])) {
					return $data['token'];
				} else {
					throw new Exception('Invalid token response format: ' . $response);
				}
			} else {
				throw new Exception('Failed to fetch auth token. HTTP Code: ' . $httpCode . ' Response: ' . $response);
			}
		} catch (Exception $e) {
			global $res;
			$res['code'] = 5;
			$res['msg'] = 'Auth Token Error: ' . $e->getMessage();
			$res['msgCode'] = 3;
			http_response_code(500);
			echo json_encode($res);
			exit;
		}
	}
?>